﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager.Utilities; 


namespace VeteransAffairs.Registries.BusinessManager
{
    public class VTADoDDataManager: BaseBO
    {

        public VTADoDDataManager() 
        {
            _defaultSortField = "ICD9_CODE desc";
            
        }

        public VTA_PATIENT GetPatientVTAInfoByReferralId(int id)
        {
            VTA_PATIENT patient;
            using (_db = GetDataContext())
            {
                patient = (from e in _db.VTA_PATIENTs where e.Patient_ID == id select e).FirstOrDefault(); 

            }

            return patient;
        }

        private IQueryable<VTA_PATIENT_ICD9> LinqICD9All()
        {
            //populate LinqAll
            IQueryable<VTA_PATIENT_ICD9> tempLinq = (from e in _db.VTA_PATIENT_ICD9s
                                                     select e);

            //TODO - add all business filtering rules 

            return tempLinq;

        }

        private IQueryable<VTA_PATIENT_ICD9> SelectByStatusLinqFilter(int id)
        {
            var linqFilter = LinqICD9All();

            linqFilter = from t in linqFilter
                         where t.VTA_PATIENT.Patient_ID == id
                         select t;


            return linqFilter;

        }

        public List<ICD9Detail> SelectICD9CodesByPatient(int id, string sort, int maxRows, int startRow)
        {
            if (string.IsNullOrEmpty(sort))
            {
                sort = _defaultSortField;
            }

            using (_db = GetDataContext())
            {
                var entities = (from t in SelectByStatusLinqFilter(id) select t).OrderBy(sort).Skip(startRow).Take(maxRows).ToList();

                return entities.Select(e => new ICD9Detail
                {
                    Code = e.ICD9_CODE,
                    Description = (_db.STD_ICD9s.Where(s => s.CODE == e.ICD9_CODE).FirstOrDefault() == null ? String.Empty : _db.STD_ICD9s.Where(s => s.CODE == e.ICD9_CODE).FirstOrDefault().DESCRIPTION_TEXT)

                }).ToList();
            }
        }

        public int SelectICD9CodesByPatientCount(int id)
        {
            using (_db = GetDataContext())
            {
                //SetLoadWith(_db);
                return SelectByStatusLinqFilter(id).Count();
            }
        }

        private IQueryable<VTA_PATIENT_SOAP_KEYWORD> LinqSoapNotesAll()
        {
            //populate LinqAll
            IQueryable<VTA_PATIENT_SOAP_KEYWORD> tempLinq = (from e in _db.VTA_PATIENT_SOAP_KEYWORDs
                                                     select e);
            //TODO - add all business filtering rules 
            return tempLinq;
        }

        private IQueryable<VTA_PATIENT_SOAP_KEYWORD> SelectByStatusNotesLinqFilter(int id)
        {
            var linqFilter = LinqSoapNotesAll();

            linqFilter = from t in linqFilter
                         where t.VTA_PATIENT.Patient_ID == id
                         select t;

            return linqFilter;
        }

        public List<VTA_PATIENT_SOAP_KEYWORD> SelectSoapNoteByPatient(int id, string sort, int maxRows, int startRow)
        {
            if (string.IsNullOrEmpty(sort))
            {
                sort = "SOAP_KEYWORD asc";
            }

            using (_db = GetDataContext())
            {
                var entities = (from t in SelectByStatusNotesLinqFilter(id) select t).OrderBy(sort).Skip(startRow).Take(maxRows).ToList();

                return entities; 
            }            
        }

        public int SelectSoapNoteByPatientCount(int id)
        {
            using (_db = GetDataContext())
            {
                //SetLoadWith(_db);
                return SelectByStatusNotesLinqFilter(id).Count();
            }
        }
        public class ICD9Detail
        {
            public string Code { get; set; }
            public string Description { get; set; }

        }

    }


}
